/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util.client;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.api.util.FramedProperties;

public interface OutlineRender {
    public static final Quaternion[] YN_DIR = OutlineRender.makeQuaternionArray();

    default public void draw(BlockState state, Level level, BlockPos pos, PoseStack poseStack, VertexConsumer builder) {
        this.draw(state, poseStack, builder);
    }

    public void draw(BlockState var1, PoseStack var2, VertexConsumer var3);

    default public Direction getRotationDir(BlockState state) {
        return (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
    }

    default public void rotateMatrix(PoseStack poseStack, BlockState state) {
        Direction dir = this.getRotationDir(state);
        Preconditions.checkState((boolean)dir.m_122434_().m_122479_(), (Object)"Rotation direction must be horizontal");
        poseStack.m_85845_(YN_DIR[dir.m_122416_()]);
    }

    public static void mirrorHorizontally(PoseStack pstack, boolean rotY90) {
        pstack.m_85845_(Quaternions.ZP_180);
        if (rotY90) {
            pstack.m_85845_(Quaternions.YN_90);
        }
    }

    public static void drawLine(VertexConsumer builder, PoseStack mstack, double x1, double y1, double z1, double x2, double y2, double z2) {
        float nX = (float)(x2 - x1);
        float nY = (float)(y2 - y1);
        float nZ = (float)(z2 - z1);
        float nLen = Mth.m_14116_((float)(nX * nX + nY * nY + nZ * nZ));
        builder.m_85982_(mstack.m_85850_().m_85861_(), (float)x1, (float)y1, (float)z1).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_85977_(mstack.m_85850_().m_85864_(), nX /= nLen, nY /= nLen, nZ /= nLen).m_5752_();
        builder.m_85982_(mstack.m_85850_().m_85861_(), (float)x2, (float)y2, (float)z2).m_85950_(0.0f, 0.0f, 0.0f, 0.4f).m_85977_(mstack.m_85850_().m_85864_(), nX, nY, nZ).m_5752_();
    }

    public static Quaternion[] makeQuaternionArray() {
        Quaternion[] array = new Quaternion[4];
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            array[dir.m_122416_()] = Vector3f.f_122224_.m_122240_(dir.m_122435_());
        }
        return array;
    }
}

